
markup.push({
		
// MARK: ducking block

DuckingBlock:
{
	"+": "BlockTemplate",
    geNodeClass: "GEDuckingNode",
	gxFaceModel: {
		nsClass: "H4DuckingBlockFace",
		gxFaceModelKeyPath: "faceModel",
	},
	minimumInputs: 2,	// always show 2 inputs connections
    h4PresetsId: "DuckingPresets4",
	gxLibraryDescription: "Duck one audio signal under another",
	gxTitle: "Ducking",
	gxPopoverInfo: "DuckingPopover",
	gxLibraryIcon: "library.ducking",
	gxSocketView: "DuckingSocketView",
	gxChildViews:
	{
		statusLight: {
			nsClass: "GXDrawView",
            gxBackPainter: {
                "+": "ImagePainter.block.ducking",
                gxTintColor: "ColorThemeLive3",
                disabled: { gxTintColor: "ForeColorTheme1" }
            },
			gxDisableOnKey: "statusLightDisabled",
			gxAnimateOnKey: "running",
            gxAnimationDivider: 4,  // 15fps
			gxFrameRect: "0, 10, 120, 110"
		},
	}
},
	
DuckingSocketView:
{
	"+": "SocketView",
	//gxAnimateOnKey: "block.running",
	gxIndicatorPainter:
	{
		nsClass: "GXImagePainter",
		gxHAlign: 0.5,
		gxVAlign: 0.5,
		gxImage: "ducking.duckee",
		signalInput: {
			gxImage: "ducking.ducker",
		},
		active : {
			gxTintColor: "BlackColor",
		},
		gxTintColor: "ForeColorTheme1",
		gxEdgeInsets: "1.5, 1.5, 1.5, 1.5",
	},
},
	
	

// MARK: ducking popover

DuckingPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Ducking",
	gxLayout: [	"H:|-12-[self(350)]-12-|",
				"V:|-12-[self]-12-|",
				"V:|-41-[mainGroup]-6-[presetsGroup]" ],
	gxChildViews:
	{
		title: "PopoverTitle",
		onOff: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		mainGroup:
		{
			"+": "GroupView",
			gxLayout:
			[
				"H:|-0-[self]-0-|",
				"V:|-13-[statusLight(34)]-13-[icon1(20)]-(-2)-[threshold(23)]-4-[text1(14)]-12-[icon2(20)]-(-2)-[volume(23)]-4-[text2(14)]-10-[hintsGroup]-0-|",
				
				"H:|-14-[threshold]-14-|",
				"H:|-14-[icon1(18)]-4-[thresholdLabel]&alignCenterY",
				"V:[thresholdReadout]-(-1)-[threshold]&alignRight",

				"H:|-84-[statusLight(34)]-4-[lightLabel(120)]",
				"V:|-23-[lightLabel]",
				
				"H:|-14-[text1]-14-|",
				
				"H:|-14-[volume]-14-|&alignCenterY",
				"H:|-14-[icon2(18)]-4-[volumeLabel]&alignCenterY",
				"V:[volumeReadout]-(-1)-[volume]&alignRight",

				"H:|-14-[text2]-14-|"
			],
			gxChildViews:
			{
				statusLight: {
					nsClass: "GXDrawView",
					gxBackPainter: {
						"+": "ImagePainter.library.ducking",
						gxTintColor: "ColorLive1",
						disabled: { gxTintColor: "ColorTheme1.blockDisabled", }
					},
					gxDisableOnKey: "statusLightDisabled",
					gxAnimateOnKey: "running",
					gxAnimationDivider: 4,  // 15fps
				},
				lightLabel: {
					"+": "LabelView",
					gxForePainter: {
						"+": "LabelFore.left",
						gxFontColor: "ColorLive1",
						gxDefaultString: "Ducking Active",
						disabled: {
							gxDefaultString: "Ducking Inactive",
							gxFontColor: "ColorTheme1.blockDisabled",
						}
					},
					gxDisableOnKey: "statusLightDisabled",
					gxAnimateOnKey: "running",
				},
				threshold : {
					"+": "SliderView",
					gxValueKey: "node.threshold",
					gxRangeMin: -60,
					gxRangeMax: 0,
					axFormatter: "DBFormatter",
					gxLabelText: "Overlay Threshold",
					axTitle: "Overlay Threshold"
				},
				thresholdReadout: {
					"+": "ReadoutView",
					gxFormatter: "DBFormatter",
					gxValueKey: "node.threshold",
				},
//				meterHostView: {
//					nsClass: "GXLayerHostingView",
//					gxLayerZPosition: 2,
//					gxLayout: [
//						"H:|-0-[peak]-0-|",
//						"V:|-0-[peak(8)]",
//					],
//					gxRootLayer:
//					{
//						nsClass: "GXDrawLayer",
//						gxLayerZPosition: 10,
//						gxSublayers:
//						{
//							peak: {
//								"+": "PeakLayer",
//								gxValueKey: "node.peakMeterValue",
//								gxAnimateOnKey: "running",
//							},
//						}
//					}
//				},
				icon1: {
					nsClass: "GXDrawView",
					gxBackPainter: "ImagePainter.foreColor1.ducking.ducker"
				},
				text1: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "The overlay source is heard when it meets this threshold."
				},
				volume: {
					"+": "SliderView",
					gxValueKey: "node.duckedGain",
					axTitle: "Ducked Volume",
					axFormatter: "PercentFormatter",
					gxLabelText: "Ducked Volume"
				},
				volumeReadout: {
					"+": "ReadoutView",
					gxFormatter: "PercentFormatter",
					gxValueKey: "node.duckedGain",
				},
				icon2: {
					nsClass: "GXDrawView",
					gxBackPainter: "ImagePainter.foreColor1.ducking.duckee"
				},
				text2: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "Other sources will be reduced to this level when ducked."
				},
				hintsGroup: {
					"+": "ExpandingGroupView",
					gxValueKey: "uiState.hintsCollapsed",
					gxCollapsedSize: 36,
					gxExtraSize: 12,
					gxLayout: [
						"H:|-0-[self]-0-|",
						"H:|-14-[infoIcon(16)]-8-[hintsText]-10-|",
						"V:|-38-[infoIcon]",
						"V:|-35-[hintsText(86)]",
					],
					gxChildViews: {
						advancedBtn: {
							"+": "AdvancedGroupButton",
							gxTitle: "<disclosure/> Hints",
							axFormatter: disclosureAxFormatter("Hints"),
							gxValueKey: "uiState.hintsCollapsed",
							axHelp: "Reveals additional hints when expanded",
						},
						infoIcon: { "+": "InfoIcon" },
						hintsText: {
							"+": "DescriptionLabelView",
							gxDefaultValue: "The Ducking block triggers when the overlay source reaches the specified threshold. Overlay audio will play through, while other sources have their volume ducked.\n\nAt all other times, the overlay source is muted while all other sources play through at full volume."
						}
					}
				}
			}
		}
	}
},
	


})
